//
//  OPKeySet.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2015-03-19.
//
//

#import <Foundation/Foundation.h>

@class OPSymmetricKey;
@class OPKeyPair;

@interface OPKeySet : NSObject

@property (nonatomic, readonly) NSString *kid;
@property (nonatomic, readonly) OPSymmetricKey *symKey;
@property (nonatomic, readonly) OPKeyPair *keyPair;

+ (OPKeySet *)generate;

+ (OPKeySet *)decryptJSON:(NSDictionary *)ciphertext withSymKey:(OPSymmetricKey *)key error:(NSError **)error;
+ (OPKeySet *)decryptJSON:(NSDictionary *)ciphertext withKeyPair:(OPKeyPair *)keyPair error:(NSError **)error;

- (id)initWithJSON:(NSDictionary *)json;

- (NSDictionary *)encryptedJSONWithSymKey:(OPSymmetricKey *)key error:(NSError **)error;

@end
